/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.RelativePosition;
import com.roguewave.chart.core.v2_1.graphics.StandardColors;
import com.roguewave.chart.standard.v2_1.parts.SingleRowLegendDrawable;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;

public class SingleRowLegend
implements Customizer {
    private final Font defaultLegendItemFont = new Font("TimesRoman", 1, 14);
    private final double defaultLegendItemBoxSize = 14.0;
    String[] legendItems_;
    Color[] colors_;

    public SingleRowLegend() {
        this.legendItems_ = null;
        this.colors_ = null;
    }

    public SingleRowLegend(String[] legendItems, Color[] colors) {
        this.legendItems_ = legendItems;
        this.colors_ = colors;
    }

    public Drawable getDrawable(ChartProperties properties, DataModel data) {
        Font font = (Font)properties.getProperty("LegendItemFont", this.defaultLegendItemFont);
        if (this.legendItems_ == null) {
            StandardColors stdColors = new StandardColors();
            this.legendItems_ = new String[data.getRowCount()];
            this.colors_ = new Color[this.legendItems_.length];
            for (int i = 0; i < this.legendItems_.length; ++i) {
                this.legendItems_[i] = data.getRowLabel(i);
                this.colors_[i] = properties.getColor(i, 0, stdColors.color(i), 0.0);
            }
        }
        int legendItemBoxSize = (int)(properties.getProperty("LegendItemBoxSize", 14.0) + 0.5);
        Color textColor = (Color)properties.getProperty("LegendTextColor", Color.black);
        Color backgroundColor = (Color)properties.getProperty("LegendBackgroundColor", Color.lightGray);
        RelativePosition position = new RelativePosition(0.5, 1.0, 0, -12, 3);
        position = (RelativePosition)properties.getProperty("LegendPosition", position);
        return new SingleRowLegendDrawable(this.legendItems_, this.colors_, position, font, legendItemBoxSize, textColor, backgroundColor);
    }

    public Customizer getLegend() {
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }
}

